/*
 * Decompiled with CFR 0.152.
 */
package com.bosschongsheng.network;

import com.bosschongsheng.config.BossRespawnConfigClient;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public record PacketBossRespawnList(List<BossRespawnConfigClient.RuleEntry> list, boolean reloadSuccess) {
    public PacketBossRespawnList(List<BossRespawnConfigClient.RuleEntry> list) {
        this(list, false);
    }

    public static void encode(PacketBossRespawnList pkt, FriendlyByteBuf buf) {
        buf.writeBoolean(pkt.reloadSuccess());
        List<BossRespawnConfigClient.RuleEntry> list = pkt.list();
        buf.writeInt(list.size());
        for (BossRespawnConfigClient.RuleEntry e : list) {
            buf.m_130070_(e.structureId());
            buf.m_130070_(e.triggerItemId());
            buf.m_130070_(e.entityTypeId());
        }
    }

    public static PacketBossRespawnList decode(FriendlyByteBuf buf) {
        boolean reloadSuccess = buf.readBoolean();
        int size = buf.readInt();
        ArrayList<BossRespawnConfigClient.RuleEntry> list = new ArrayList<BossRespawnConfigClient.RuleEntry>();
        for (int i = 0; i < size; ++i) {
            list.add(new BossRespawnConfigClient.RuleEntry(buf.m_130277_(), buf.m_130277_(), buf.m_130277_()));
        }
        return new PacketBossRespawnList(list, reloadSuccess);
    }

    public static void handle(PacketBossRespawnList pkt, NetworkEvent.Context ctx) {
        ctx.enqueueWork(() -> {
            BossRespawnConfigClient.setRuleList(pkt.list());
            if (pkt.reloadSuccess()) {
                try {
                    Class.forName("com.bosschongsheng.client.ClientPackets").getMethod("showReloadSuccessMessage", new Class[0]).invoke(null, new Object[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException("Show reload message (client)", e);
                }
            }
        });
        ctx.setPacketHandled(true);
    }
}

